# Starter Worlds 🌍

**12 focused lessons to learn VR world creation**

Each file teaches ONE concept. Open them in order, read the comments, and experiment!

---

## The Lessons

| # | File | What You'll Learn |
|---|------|-------------------|
| 01 | `01-first-world.html` | The absolute basics - a box and a sky |
| 02 | `02-shape-gallery.html` | All the primitive shapes you can use |
| 03 | `03-position-rotation-scale.html` | How to place and transform objects |
| 04 | `04-build-a-tree.html` | Combining shapes to make complex objects |
| 05 | `05-animation.html` | Making things move, spin, pulse, and fade |
| 06 | `06-interaction.html` | Hover effects and click responses |
| 07 | `07-javascript-creation.html` | Creating objects with code and loops |
| 08 | `08-random-forest.html` | Using Math.random() for variety |
| 09 | `09-seeded-random.html` | **KEY CONCEPT**: Same seed = same world |
| 10 | `10-crystal-game.html` | A complete collectible game |
| 11 | `11-changing-skies.html` | Atmosphere and mood with sky palettes |
| 12 | `12-infinite-chunks.html` | **ADVANCED**: Chunk-based infinite worlds |

---

## How to Use

1. **Open any `.html` file** directly in your browser (Chrome, Firefox, Edge)
2. **Read the comments** at the top - they explain what to try
3. **Edit the code** - change numbers, colors, add things
4. **Break it, then fix it** - this is how you learn!

---

## Quick Reference

### Basic Shapes
```html
<a-box position="0 1 -3" color="red"></a-box>
<a-sphere position="0 1 -3" radius="0.5" color="blue"></a-sphere>
<a-cylinder position="0 1 -3" radius="0.3" height="2" color="green"></a-cylinder>
<a-cone position="0 1 -3" radius-bottom="1" height="2" color="yellow"></a-cone>
<a-plane rotation="-90 0 0" width="10" height="10" color="gray"></a-plane>
```

### Position
```
X = left(-) / right(+)
Y = down(-) / up(+)
Z = forward(-) / backward(+)

position="X Y Z"
```

### Animation
```html
<a-box animation="property: rotation; to: 0 360 0; dur: 2000; loop: true"></a-box>
```

### Movement Controls
```html
<a-entity camera look-controls wasd-controls position="0 1.6 0"></a-entity>
```

---

## Learning Path

**Beginner** (30 min)
- 01 → 02 → 03 → 04

**Intermediate** (1 hour)  
- 05 → 06 → 07 → 08

**Advanced** (1-2 hours)
- 09 → 10 → 11 → 12

---

## After Completing These

You're ready for the **Infinite Forward** project! It combines all these concepts into a complete, atmospheric procedural world experience.

---

## Tips

- **View Source**: Right-click → View Page Source to see the code
- **Developer Console**: Press F12 to see errors and console.log() messages
- **VR Mode**: Click the VR goggles icon (works with Quest 3!)
- **Get Stuck?**: Change ONE thing at a time, then reload

---

## Colors You Can Use

```
Named: red, blue, green, yellow, orange, purple, pink, white, black, gray
Hex: #FF0000, #00FF00, #0000FF, #FFFF00
RGB: rgb(255, 0, 0)
HSL: hsl(120, 100%, 50%)
```

---

*Happy building! The worlds are waiting for you to create them.*
